class DanishTeamScoreboard extends TeamScoreBoard;

var int GameTypeColorR, ColorUpDownR, GameTypeColorG, ColorUpDownG, GameTypeColorB, ColorUpDownB, EFFcolor, EFFupdown;



function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;
	
	// GameType colorflash
			// rd farve palette
			if (ColorUpDownR == 0)
				{
				GameTypeColorR += 4;
				if (GameTypeColorR >= 255)
					{
					GameTypeColorR = 255;
					ColorUpDownR = 1;
					}

				}
			if (ColorUpDownR == 1)
				{
				GameTypeColorR -= 4;
				if (GameTypeColorR <= 0)
					{
					GameTypeColorR = 0;
					ColorUpDownR = 0;
					}

				}
			// grn farve palette
			if (ColorUpDownG == 0)
				{
				GameTypeColorG += 3;
				if (GameTypeColorG >= 255)
					{
					GameTypeColorG = 255;
					ColorUpDownG = 1;
					}

				}
			if (ColorUpDownG == 1)
				{
				GameTypeColorG -= 3;
				if (GameTypeColorG <= 0)
					{
					GameTypeColorG = 0;
					ColorUpDownG = 0;
					}

				}
			// bl farve palette
			if (ColorUpDownB == 0)
				{
				GameTypeColorB += 2;
				if (GameTypeColorB >= 255)
					{
					GameTypeColorB = 255;
					ColorUpDownB = 1;
					}

				}
			if (ColorUpDownB == 1)
				{
				GameTypeColorB -= 2;
				if (GameTypeColorB <= 0)
					{
					GameTypeColorB = 0;
					ColorUpDownB = 0;
					}

				}



			Canvas.DrawColor.R = GameTypeColorR;
			Canvas.DrawColor.G = GameTypeColorG;
			Canvas.DrawColor.B = GameTypeColorB;







	Canvas.DrawText(TGRI.GameName);
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, Canvas.CurY - YL);

	Canvas.DrawColor.R = 255;
	Canvas.DrawColor.G = 255;
	Canvas.DrawColor.B = 255;

	if ( TGRI.FragLimit > 0 )
	{
		Canvas.DrawText(FragGoal@TGRI.FragLimit);
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.CurY - YL);
	}

	if ( TGRI.TimeLimit > 0 )
		Canvas.DrawText(TimeLimit@TGRI.TimeLimit); //":00"
}




function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL, YL, XL2, YL2, YB;
	local BotReplicationInfo BRI;
	local String S, O, L;
	local Font CanvasFont;
	local bool bAdminPlayer;
	local PlayerPawn PlayerOwner;
	local int Time;
	local float ResA;
	local float ResB;
	local float EFF;
	local int ResultEFF;

	PlayerOwner = PlayerPawn(Owner);

	bAdminPlayer = PRI.bAdmin;

	// Draw Name
	if (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName)
		{
		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
		}
	else 
		{
		Canvas.DrawColor.R = 0;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
		}

	Canvas.SetPos(XOffset, YOffset);
	Canvas.DrawText(PRI.PlayerName, False);
	Canvas.StrLen(PRI.PlayerName, XL, YB);

	if ( Canvas.ClipX > 512 )
	{
		CanvasFont = Canvas.Font;
		Canvas.Font = Font'SmallFont';
		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 255;

		if (Level.NetMode != NM_Standalone)
		{
			if ( !bCompressed || (Canvas.ClipX > 640) )
			{
				// Draw Time
				Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
				Canvas.StrLen(TimeString$":     ", XL, YL);
				Canvas.SetPos(XOffset - XL - 6, YOffset);
				Canvas.DrawText(TimeString$":"@Time, false);
			}

			// Draw Ping
			Canvas.StrLen(PingString$":     ", XL2, YL2);
			Canvas.SetPos(XOffset - XL2 - 6, YOffset + (YL+1));
			Canvas.DrawText(PingString$":"@PRI.Ping, false);
			


// udregn eff

	ResA = PRI.Score;
	if (ResA < 0)
		{
		ResA = 0;
		}
	ResB = ResA;
	ResA += PRI.Deaths;
//	ResB = PRI.Score;
	ResB /=ResA;
	ResB *=100;
	ResultEFF = ResB;



//-------------------------------------------------------------
// start - vis eff i forskellige farver
	if (ResultEFF >= 100)
		{
		// EFF farve flash
			if (EFFupdown == 0)
				{
				EFFcolor += 12;
				if (EFFColor >= 255)
					{
					EFFcolor = 255;
					EFFupdown = 1;
					}

				}
			if (EFFupdown == 1)
				{
				EFFcolor -= 12;
				if (EFFcolor <= 0)
					{
					EFFcolor = 0;
					EFFupdown = 0;
					}

				}
		Canvas.DrawColor.R = EFFcolor;
		Canvas.DrawColor.G = EFFcolor;
		Canvas.DrawColor.B = EFFcolor;
		}
	else if (ResultEFF >= 67)
		{
		Canvas.DrawColor.R = 0;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
		}
	else if (ResultEFF >= 34)
		{
		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
		}
	else
		{
		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 0;
		Canvas.DrawColor.B = 0;
		}
	
// slut - vis eff i forskellige farver
//-------------------------------------------------------------








			// Draw eff
			Canvas.StrLen(PingString$":     ", XL2, YL2);
			Canvas.SetPos(XOffset - XL2 - 6, YOffset + 25);
			Canvas.DrawText("EFF :"@ResultEFF$"%", false);


		}
		Canvas.Font = CanvasFont;
	}

	// Draw Score
	if (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName)
		{
		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
		}
	else
		{
		Canvas.DrawColor.R = 0;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
		}
	DrawScore(Canvas, PRI.Score, XOffset, YOffset);

	if (Canvas.ClipX < 512)
		return;

	// Draw location, Order
	if ( !bCompressed && (PRI.Team == OwnerInfo.Team) )
	{
		CanvasFont = Canvas.Font;
		Canvas.Font = Font'SmallFont';

		if ( PRI.PlayerLocation != None )
			L = PRI.PlayerLocation.LocationName;
		else if ( PRI.PlayerZone != None )
			L = PRI.PlayerZone.ZoneName;
		else
			L = "";
		if ( L != "" )
		{
			L = InString@L;
			Canvas.SetPos(XOffset, YOffset + YB);
			Canvas.DrawText(L, False);
		}
		O = OwnerGame.GetOrderString(PRI);
		if (O != "")
		{
			O = OrdersString@O;
			Canvas.StrLen(O, XL2, YL2);
			Canvas.SetPos(XOffset, YOffset + YB + YL2);
			Canvas.DrawText(O, False);
		}
		Canvas.Font = CanvasFont;
	}
}




